//#define TRACESTREAM
using System;
using System.IO;
using System.Net;
using System.Xml;
using System.Threading;
using System.Diagnostics;
using System.Collections;
using System.Net.Sockets;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Soap;

using Team_Project;
using Team_Project.Elements;
using Team_Project.Exceptions;
using Team_Project.PersistencyManagers;
using Team_Project.PersistencyManagers.Storages;
using Team_Project.PersistencyManagers.Protocols;

namespace Team_Project
{
	public class ConfirmHandler
	{
		private delegate void ConnectDelegate(EndPoint ep);
		protected class Data
		{
			public Data(ArrayList a)
			{
				NameList = a;
				TID = Thread.CurrentThread;
			}
			public ArrayList NameList = new ArrayList();
			public Thread TID;
			public LockElement overriderLock = null;
		}

		protected static void AwaitCompletition(IAsyncResult aRes,string copyName)
		{
			int waited = 0;
			while(waited <= Globals.Instance.TimeOut)
			{
				if(aRes.IsCompleted) break;
				waited += Globals.Instance.PollTime;
				Thread.Sleep(Globals.Instance.PollTime);
			}
			if(waited > Globals.Instance.TimeOut)
			{
				((CopiesTreeManager)Globals.Instance.Data["TreeManager"]).RemoveCopy(copyName);
				throw new TimeOutException("",copyName);
			}
		}

		protected static Hashtable handlers = new Hashtable(5);
		protected static Hashtable Cancelled = new Hashtable(5);

		protected static NetworkStream OpenTo(string copyName,out Socket s)
		{
			s = new Socket(AddressFamily.InterNetwork,SocketType.Stream,ProtocolType.Tcp);
			Trace.Write("Trying to conneect to " + copyName);
			Trace.WriteLine("("+MyDNS.ResolveIP(copyName).ToString()+":"
				+MyDNS.ListenerPort(copyName).ToString()+")");
			ConnectDelegate cdel = new ConnectDelegate(s.Connect);
			IAsyncResult ar = cdel.BeginInvoke(new IPEndPoint(MyDNS.ResolveIP(copyName),MyDNS.ListenerPort(copyName)),null,null);
			try
			{
				AwaitCompletition(ar,copyName);
				cdel.EndInvoke(ar);
				return new NetworkStream(s);
			}
			catch{return null;}
		}

		public static void StopWaitingFor(LockElement el,LockElement ov)
		{
			lock(handlers)
			{
				lock(Cancelled)
				{
					if(handlers.ContainsKey(el.RequestID))
					{
						Data d;
						lock(d = (Data)handlers[el.RequestID])
						{
							d.overriderLock = ov;
							d.TID.Resume();
						}
					}
					else
						Cancelled[el.RequestID] = ov;
				}
			}
		}
		
		public static bool SendOverrideAndWaitConfirms(ArrayList copies,LockElement el,LockElement newLock)
		{
			StopWaitingFor(el,newLock);
			if(copies.Count == 0) return true;
			lock(handlers[newLock.RequestID] = new Data(copies))
			{
				lock(copies)
				{
					for(int i = 0; i <copies.Count;)
					{
						string cpN = (string)copies[i];
						Socket skt;
						NetworkStream NetS = OpenTo(cpN,out skt);
						if(NetS == null)
						{
							copies.RemoveAt(i);
							continue;
						}
						StreamWriter sw = new StreamWriter(NetS);
						Trace.WriteLine("Sending override notification to " + cpN);
						sw.WriteLine("LK_OVERRIDE");
						sw.WriteLine(Globals.Instance.LocalCopyName);
						sw.Flush();
						SoapFormatter sf = new SoapFormatter();
						sf.Serialize(NetS,new ValueLockElement(el));
						sf.Serialize(NetS,new ValueLockElement(newLock));
						Trace.WriteLine("Sending complete");
						NetS.Flush();
						skt.Shutdown(SocketShutdown.Both);
						NetS.Close();
						i++;
					}
				}
			}
			return WaitConfirms(newLock.RequestID,out el);
		}

		protected static bool WaitConfirms(string req, out LockElement newLock)
		{
			lock(handlers)
			{
				if(handlers.Count == 1)
				{
					Trace.WriteLine("LockHandler: registering for copyRemoved");
					CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
					ctm.CopyRemoved +=new CopyEventDelegate(ctm_CopyRemoved);
				}
			}
			newLock = null;
			Trace.WriteLine("Suspending thread waiting for confirms");
			Thread.CurrentThread.Suspend();
			Trace.WriteLine("Thread Awake");
			Data d;
			lock(d = (Data)handlers[req])
			{
				handlers.Remove(req);
				if(handlers.Count == 0)
				{
					Trace.WriteLine("LockHandler: UNregistering for copyRemoved");
					CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
					ctm.CopyRemoved -=new CopyEventDelegate(ctm_CopyRemoved);
				}
				if(d.overriderLock == null)
				{
					Trace.WriteLine("Confirms for "+ req + " received. Lock ok");
					return true;
				}
				else
				{
					Trace.WriteLine("Override received");
					newLock = d.overriderLock;
					return false;
				}
			}
		}

		public static bool SendRequestAndWaitConfirms(ArrayList copies,LockElement el,out LockElement newLock)
		{
			lock(Cancelled)
			{
				newLock = (LockElement)Cancelled[el.RequestID];
				if(newLock != null)
				{
					Trace.WriteLine("Concurrency: Request overridden before been completed");
					return false;
				}
			}
			if(copies.Count == 0) return true;
			lock(handlers[el.RequestID] = new Data(copies))
			{
				lock(copies)
				{
					for(int i = 0; i< copies.Count;)
					{
						string cpN =(string) copies[i];
						Socket skt;
						NetworkStream NetS = OpenTo(cpN,out skt);
						if(NetS == null)
						{
							copies.RemoveAt(i);
							continue;
						}
						StreamWriter sw = new StreamWriter(NetS);
						Trace.WriteLine("Sending request to " + cpN);
						sw.WriteLine("LK_REQ");
						sw.WriteLine(Globals.Instance.LocalCopyName);
						sw.Flush();
						SoapFormatter sf = new SoapFormatter();
						/*************************************/
						//MemoryStream mem = new MemoryStream();
						sf.Serialize(/*mem*/NetS,new ValueLockElement(el));
						/*mem.Flush();
							mem.Seek(0,SeekOrigin.Begin);
							Trace.WriteLine("Tracing content of stream");
							int i;
							while(mem.Position < mem.Length)
							{
								i = mem.ReadByte();
								Trace.Write((char)i);
								NetS.WriteByte((byte)i);
							}
							Trace.WriteLine("");
							mem.Close();*/
						Trace.WriteLine("Sending complete");
						NetS.Flush();
						skt.Shutdown(SocketShutdown.Both);
						NetS.Close();
						i++;
					}
				}
			}
			return WaitConfirms(el.RequestID,out newLock);
		}

		public static void ConfirmReceived(string requestID,string source)
		{
			Data d;
			lock (handlers)
			{
				d = (Data)handlers[requestID];
				if(d == null)
				{
					Trace.WriteLine("Not wainting confirm for " + requestID + ": IGNORING");
					return;
				}

				lock(d)
				{
					lock(d.NameList)
					{
						Trace.WriteLine("Before remove of " + source + ": " +d.NameList.Count);
						d.NameList.Remove(source);
						Trace.WriteLine("After remove of " + source + ": " +d.NameList.Count);
					}
					if(d.NameList.Count == 0)
					{
						Trace.WriteLine("Resuming thread");
						d.TID.Resume();
					}
				}
			}
		}

		public static bool OverrideReceived(LockElement overridden, string source, LockElement newEl)
		{
			Data d = (Data)handlers[overridden.RequestID];
			IStorage strg = Globals.Instance.Storages.GetStorageFor(overridden.Project,typeof(LockElement));
			if(d != null)
			{
				lock(d)
				{
					Trace.WriteLine("Override for a waiting thread. Leaving command to it");
					d.overriderLock = newEl;
					d.TID.Resume();
				}
			}
			else
			{
				Trace.WriteLine("Alredy given confirm for " + overridden.RequestID);
				if(strg.Exists(overridden.Location, overridden.Name))
				{
					Globals.Instance.Mutexes.RequestWrite(overridden.Project,overridden.Location,overridden.Name);
					try
					{
						Trace.WriteLine("Deleting old lock: " + overridden.ToString());
						overridden.DestroyFrom(strg);}
					finally
					{Globals.Instance.Mutexes.ReleaseWrite(overridden.Project,overridden.Location,overridden.Name);}
				}
			}
			Trace.WriteLine("Writing overrider Lock:" + newEl.ToString());
			Globals.Instance.Mutexes.RequestWrite(newEl.Project,newEl.Location,newEl.Name);
			try
			{newEl.WriteTo(strg);}
			finally
			{Globals.Instance.Mutexes.ReleaseWrite(newEl.Project,newEl.Location,newEl.Name);}

			CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
			ArrayList copies = new ArrayList(ctm.GetChildren());
			if(ctm.GetParent() != string.Empty)
				copies.Add(ctm.GetParent());
			copies.Remove(source);
			Trace.WriteLine("Sending Override notifications");
			bool ok = SendOverrideAndWaitConfirms(copies,overridden,newEl);
			if(!ok)
			{
				Trace.WriteLine("Another override received (ov 2 ov)");
			}
			return ok;
		}

		public static void SendConfirm(string to, string requestID)
		{
			//Thread.Sleep(2000);
			Trace.WriteLine("Sending confirm to " + to + " for " + requestID);
			Socket sk;
			NetworkStream NetS = OpenTo(to,out sk);
			if(NetS == null) return;
			StreamWriter sw = new StreamWriter(NetS);
			sw.WriteLine("LK_CONFIRM");
			sw.WriteLine(requestID);
			sw.WriteLine(Globals.Instance.LocalCopyName);
			sw.Flush();
			sk.Shutdown(SocketShutdown.Both);
			sw.Close();
			Trace.WriteLine("Sending confirm Completed");
		}

		private static void ctm_CopyRemoved(object source, TPCopyEventArgs args)
		{
			Trace.WriteLine("ctm_CopyRemoved called. Removing " + args.CopyName);
			ArrayList toSignal = new ArrayList(2);
			//E' necessario eliminare le richieste di attesa delle conferme da parte della copia
			//eliminata. Per fare questo si simula l'arrivo di una conferma cos
			//da riutilizzare il codice per la gestione dell'eliminazione di una copia.
			lock(handlers)
			{
				foreach(string k in handlers.Keys)
				{
					Data d = (Data)handlers[k];
					lock(d)
					{
						//if(d.NameList.Contains(args.CopyName))
							toSignal.Add(k);
					}
				}
			}
			foreach(string k in toSignal)
				ConfirmReceived(k,args.CopyName);
		}
	}


	public class LockHandlerThread : IMessageHandler
	{
		protected string message;
		Socket skt;
		Stream sktstr;
		Thread t;
		
		public LockHandlerThread(string msg,Socket s,NetworkStream ns)
		{
			message = msg;
			skt = s;
			sktstr = ns;
		}

		#region IMessageHandler members

		public void Go()
		{
			switch(message)
			{
				case "LK_REQ":
					t = new Thread(new ThreadStart(HandleRequest));
					t.Start();
					break;
				case "LK_OVERRIDE":
					t = new Thread(new ThreadStart(HandleOverride));
					t.Start();
					break;
				case "LK_CONFIRM":
					string req = Bertaccini.Utils.SRead.ReadLine(sktstr);//sr.ReadLine();
					Trace.WriteLine("... for " + req);
					string src = Bertaccini.Utils.SRead.ReadLine(sktstr); //sr.ReadLine();
					Trace.WriteLine("... from " + src);
					ConfirmHandler.ConfirmReceived(req,src);
					break;
			}
		}

		#endregion


		public static Stream TraceStream(Stream source)
		{
#if TRACESTREAM
			Trace.WriteLine("Tracing content of input stream");
			MemoryStream ms = new MemoryStream();
			int i;
			while((i = source.ReadByte()) != -1)
			{
				Trace.Write((char)i);
				ms.WriteByte((byte)i);
			}
			Trace.WriteLine("");
			ms.Flush();
			ms.Seek(0,SeekOrigin.Begin);
			return ms;
#else
			return source;
#endif
		}

		protected void HandleRequest()
		{
			Trace.WriteLine("Handling request...");
			string from = Bertaccini.Utils.SRead.ReadLine(sktstr); //sr.ReadLine();
			Trace.WriteLine("... from " + from);

			SoapFormatter sf = new SoapFormatter();
			sktstr = TraceStream(sktstr);
			LockElement le = ((ValueLockElement)sf.Deserialize(sktstr)).realElement;
			Trace.WriteLine("Request data complete, shutting down connection");
			skt.Shutdown(SocketShutdown.Both);
			skt.Close();
			Trace.WriteLine("Connection down");
			try
			{
				DistributedLockProtocol dlp = (DistributedLockProtocol)
					Globals.Instance.Protocols.GetProtocolFor(le.Project,le.GetType(),Direction.Store);
				dlp.Store(le,from);
				ConfirmHandler.SendConfirm(from,le.RequestID);
			}
			catch(LockOverriddenException loe)
			{
				Trace.Write("Remote request of lock [" + le.ToString() + "] overridden by ["+
					loe.OverriderLock.ToString() + "]");
				//ConfirmHandler.OverrideReceived(le,Globals.Instance.LocalCopyName,loe.OverriderLock);
				loe.OverriderLock.Dispose();
			}
			le.Dispose();
		}

		protected void HandleOverride()
		{
			string from = Bertaccini.Utils.SRead.ReadLine(sktstr);//sr.ReadLine();
			Trace.WriteLine("... from " + from + " (ov)");
			SoapFormatter sf = new SoapFormatter();
			LockElement oldLock = ((ValueLockElement)sf.Deserialize(sktstr)).realElement;
			LockElement newLock = ((ValueLockElement)sf.Deserialize(sktstr)).realElement;
			skt.Shutdown(SocketShutdown.Both);
			skt.Close();
			//ConfirmHandler.ConfirmReceived(newLock.RequestID,from);

			bool sendConfirm = ConfirmHandler.OverrideReceived(oldLock,from,newLock);
			if(sendConfirm)
			{
				ConfirmHandler.SendConfirm(from,newLock.RequestID);
			}
		}
	}
}